% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipmap_plot.R
\name{tipmap_plot}
\alias{tipmap_plot}
\title{Visualize tipping point analysis}
\usage{
tipmap_plot(
  tipmap_data,
  target_pop_lab = "Trial in target\\n population",
  y_range = NULL,
  y_breaks = NULL,
  title = NULL,
  y_lab = "Mean difference",
  x_lab = "Weight on informative component of MAP prior",
  map_prior_lab = "MAP\\nprior",
  meta_analysis_lab = "MA",
  legend_title = "Posterior quantile",
  null_effect = 0
)
}
\arguments{
\item{tipmap_data}{A data frame containing tipping point data, generated by \code{create_tipmap_data()}.}

\item{target_pop_lab}{A label for the trial in the target population.}

\item{y_range}{An optional argument specifying range of the y-axis.}

\item{y_breaks}{An optional vector specifying breaks on the y-axis.}

\item{title}{The plot title.}

\item{y_lab}{The label for the y axis. Defaults to "Mean difference".}

\item{x_lab}{The label for the x axis. Defaults to "Weight on informative component of MAP prior".}

\item{map_prior_lab}{The label for the MAP prior. Defaults to "MAP prior"}

\item{meta_analysis_lab}{An optional label for a meta-analysis (if included).}

\item{legend_title}{An optional title for the plot legend. Defaults to "Posterior quantiles".}

\item{null_effect}{The null treatment effect, determining where tipping points are calculated. Defaults to 0.}
}
\value{
A \code{ggplot} object of the tipping point plot
}
\description{
Uses a data frame created by \code{create_tipmap_data()} to visualize the tipping point analysis.
}
\examples{

tipmap_data <- load_tipmap_data("tipdat.rds")
tipmap_plot(tipmap_data)

}
\seealso{
\code{\link{create_tipmap_data}}
}
