% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_summary.R
\name{density.summary_fitsae}
\alias{density.summary_fitsae}
\title{Density Plot Function for a \code{summary_fitsae} Object}
\usage{
\method{density}{summary_fitsae}(x, grid = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{summary_fitsae}.}

\item{grid}{Logical indicating whether plots are displayed in a grid (\code{TRUE}) or in sequence (\code{FALSE}).}

\item{...}{Currently unused.}
}
\value{
Two \code{ggplot2} objects in a grid or in sequence.
}
\description{
The method \code{density()} provides, in a grid (default) or sequence, the density plot of direct estimates versus HB model estimates and the density plot of standardized posterior means of the random effects versus standard normal.
}
\examples{
library(tipsae)

# loading toy dataset
data("emilia_cs")

# fitting a model
fit_beta <- fit_sae(formula_fixed = hcr ~ x, data = emilia_cs, domains = "id",
                    type_disp = "var", disp_direct = "vars", domain_size = "n",
                    # MCMC setting to obtain a fast example. Remove next line for reliable results.
                    chains = 1, iter = 150, seed = 0)

# check model diagnostics
summ_beta <- summary(fit_beta)

# visualize estimates and random effect densities via density() function
density(summ_beta)
}
\seealso{
\code{\link{summary.fitsae}} to produce the input object.
}
