% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_test.R
\name{inline_test}
\alias{inline_test}
\alias{inline_test_p}
\title{Report a hypothesis test inline}
\usage{
inline_test(test, stat = TRUE, pval = TRUE, digits = 2)

inline_test_p(test, digits = 2)
}
\arguments{
\item{test}{An htest object}

\item{stat}{Logical, whether to report test statistic (default TRUE)}

\item{pval}{Logical, whether to report p-value (default TRUE)}

\item{digits}{Number of digits to round to (default to 2)}
}
\value{
Returns a LaTeX-formatted hypothesis test result for use in RMarkdown document.
}
\description{
\code{inline_test} formats the results of an htest object into LaTeX to be presented inline in an RMarkdown document.
}
\details{
This function currently only supports t tests and chi-squared tests. Suggestions and requests are welcomed.

\code{inline_test_p} is a wrapper for \code{inline_test} to report only the p-value (sets all non-p-value logicals to FALSE).
}
\examples{
x = rnorm(20)
test1 = t.test(x)
inline_test(test1)
inline_test_p(test1)

}
