% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_toml}
\alias{write_toml}
\alias{to_toml}
\title{Generate TOML}
\usage{
write_toml(x, file)

to_toml(x)
}
\arguments{
\item{x}{an object of class \code{Toml}.}

\item{file}{path to the file to  write.}
}
\value{
\code{write_toml()} returns a \code{Toml} object invisibly. \code{to_toml()} returns a string.
}
\description{
Write a \code{Toml} object to a file or to a string. Use \code{write_toml()} to
write to a file on disk. Or, use \code{to_toml()} to create a string
containing \code{TOML}.
}
\examples{
tmp <- tempfile(fileext = ".toml")

x <- toml(
  today = Sys.Date(),
  human = list(person = "Greg", age = 29, bday = "1969-07-02"),
)

write_toml(x, tmp)
read_toml(tmp)
to_toml(x)
}
