% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_size.R
\name{topic_size}
\alias{topic_size}
\title{Calculate the size of each topic in a topic model}
\usage{
topic_size(topic_model)
}
\arguments{
\item{topic_model}{a fitted topic model object from one of the following:
\code{\link[topicmodels]{tm-class}}}
}
\value{
A vector of topic sizes with length equal to the number of topics in the fitted model
}
\description{
Calculate the size of each topic in a topic model based on the
number of fractional tokens found in each topic.
}
\examples{

# Using the example from the LDA function
library(topicmodels)
data("AssociatedPress", package = "topicmodels")
lda <- LDA(AssociatedPress[1:20,], control = list(alpha = 0.1), k = 2)
topic_size(lda)
}
\references{
{
  Jordan Boyd-Graber, David Mimno, and David Newman, 2014.
  \emph{Care and Feeding of Topic Models: Problems, Diagnostics, and Improvements.}
  CRC Handbooks ofModern Statistical Methods. CRC Press, Boca Raton, Florida.
}
}
