% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toporanga.R
\name{toporanga}
\alias{toporanga}
\title{A catch-all function to access package functionality in one call}
\usage{
toporanga(
  winning,
  opposing,
  weight,
  ...,
  agents,
  diffuse = FALSE,
  reciprocals = c(),
  output = c("parameters", "graph", "order_sample", "subordinate_count"),
  epochs
)
}
\arguments{
\item{winning}{vector of IDs of winning agents.}

\item{opposing}{vector of IDs of opposing agents.}

\item{weight}{optional weight of the event; set to 1 for each event if not given.}

\item{...}{ignored.}

\item{agents}{optional vector of IDs of all agents; allows for ghost agents that are in the set but are not involved in any event.}

\item{diffuse}{if \code{TRUE}, weight diffusion is applied. See \code{diffuse} for more details.}

\item{reciprocals}{a vector of commands applied to the tally.
\code{"keep"} does nothing;
\code{"marginise"} reduces weights into weight margins, see \code{marginise},
\code{"zero"} zeroes opposing weights, see \code{zero_opposition},
\code{"normalise"} normalises weights within conflicts, see \code{normalise};
\code{"diffuse"} applies \code{diffuse}, allows to manage order in which diffuse is mixed with other modifiers; cannot be mixed with \code{diffuse=TRUE}.
Normally, diffuse is applied first.}

\item{output}{specifies what to return from the function.
\code{"parameters"} returns the some agent parameters, see \code{parameters};
\code{"graph"} a \code{toporanga_graph} object;
\code{"order_sample"} an order of agents; in case multiple is possible, a single random sample;
\code{"subordinate_count"} a count of subordinate agents for each agent, which can be interpreted as a dominance score.}

\item{epochs}{optional driver for applying analysis on subsets of events. See \code{cumulative_epochs} and \code{window_epochs} for more information.
If given, changes the output to an aggregated version of whatever was selected with \code{output}.}
}
\value{
A result of the caclulation in a form specified by the \code{output} argument, aggregated over epochs is \code{epochs} argument is given.
}
\description{
The general pipeline of toporanga is to tally the domination events, optionally modify the tally by diffusing event weights and/or re-scoring reciprocal weights, arrange agents into an order represented by an acyclic graph, finally to reduce it to an order or a dominance score.
This function collects all of this into a single call.
}
\examples{
data(EcoHAB)
toporanga(EcoHAB$winner,EcoHAB$loser)
}
