% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxford-pet-dataset.R
\name{oxford_pet_dataset}
\alias{oxford_pet_dataset}
\title{Oxford Pet Dataset}
\usage{
oxford_pet_dataset(
  root,
  split = "train",
  target_type = c("trimap", "species", "breed"),
  download = FALSE,
  ...,
  transform = NULL,
  target_transform = NULL
)
}
\arguments{
\item{root}{path to the data location}

\item{split}{train, test or valid}

\item{target_type}{The type of the target:
\itemize{
\item 'trimap': returns a mask array with one class per pixel.
\item 'species': returns the species id. 1 for cat and 2 for dog.
\item 'breed': returns the breed id. see \code{dataset$breed_classes}.
}}

\item{download}{wether to download or not}

\item{...}{Currently unused.}

\item{transform}{A function/transform that takes in an PIL image and returns
a transformed version. E.g, \code{\link[torchvision:transform_random_crop]{transform_random_crop()}}.}

\item{target_transform}{A function/transform that takes in the target and
transforms it.}
}
\description{
The Oxford-IIIT Pet Dataset is a 37 category pet dataset with roughly
200 images for each class. The images have a large variations in scale,
pose and lighting. All images have an associated ground truth annotation of
species (cat or dog), breed, and pixel-level trimap segmentation.
}
