% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-flowers.R
\name{flowers102_dataset}
\alias{flowers102_dataset}
\title{Oxford Flowers 102 Dataset}
\usage{
flowers102_dataset(
  root = tempdir(),
  split = "train",
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{Root directory for dataset storage. The dataset will be stored under \code{root/flowers102}.}

\item{split}{One of \code{"train"}, \code{"val"}, or \code{"test"}. Default is \code{"train"}.}

\item{transform}{Optional function to transform input images after loading. Default is \code{NULL}.}

\item{target_transform}{Optional function to transform labels. Default is \code{NULL}.}

\item{download}{Logical. Whether to download the dataset if not found locally. Default is \code{FALSE}.}
}
\value{
An object of class \code{flowers102_dataset}, which behaves like a torch dataset.
Each element is a named list:
\itemize{
\item \code{x}: a W x H x 3 numeric array representing an RGB image.
\item \code{y}: an integer label indicating the class index.
}
}
\description{
Loads the Oxford 102 Category Flower Dataset. This dataset consists of 102 flower categories,
with between 40 and 258 images per class. Images in this dataset are of variable sizes.
}
\details{
This is a \strong{classification} dataset where the goal is to assign each image to one of the 102 flower categories.

The dataset is split into:
\itemize{
\item \code{"train"}: training subset with labels.
\item \code{"val"}: validation subset with labels.
\item \code{"test"}: test subset with labels (used for evaluation).
}
}
\examples{
\dontrun{
# Load the dataset with inline transforms
flowers <- flowers102_dataset(
  split = "train",
  download = TRUE,
  transform = . \%>\% transform_to_tensor() \%>\% transform_resize(c(224, 224))
)

# Create a dataloader
dl <- dataloader(
  dataset = flowers,
  batch_size = 4
)

# Access a batch
batch <- dataloader_next(dataloader_make_iter(dl))
batch$x  # Tensor of shape (4, 3, 224, 224)
batch$y  # Tensor of shape (4,) with numeric class labels
}

}
\seealso{
Other classification_dataset: 
\code{\link{caltech_dataset}},
\code{\link{cifar10_dataset}()},
\code{\link{eurosat_dataset}()},
\code{\link{fer_dataset}()},
\code{\link{fgvc_aircraft_dataset}()},
\code{\link{image_folder_dataset}()},
\code{\link{lfw_dataset}},
\code{\link{mnist_dataset}()},
\code{\link{oxfordiiitpet_dataset}()},
\code{\link{places365_dataset}()},
\code{\link{tiny_imagenet_dataset}()},
\code{\link{whoi_plankton_dataset}()},
\code{\link{whoi_small_coralnet_dataset}()}
}
\concept{classification_dataset}
