% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-plankton.R
\name{whoi_plankton_dataset}
\alias{whoi_plankton_dataset}
\alias{whoi_small_plankton_dataset}
\title{WHOI Plankton Datasets}
\usage{
whoi_small_plankton_dataset(
  split = "val",
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)

whoi_plankton_dataset(
  split = "val",
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{split}{One of \code{"train"}, \code{"val"}, or \code{"test"}. Default is \code{"val"}.}

\item{transform}{Optional. A function that takes an image and returns a transformed version (e.g., normalization, cropping).}

\item{target_transform}{Optional. A function that transforms the label.}

\item{download}{Logical. If TRUE, downloads the dataset to \verb{root/}. If the dataset is already present, download is skipped.}
}
\value{
A torch dataset with a
\itemize{
\item \code{classes} attribute providing the vector of class names.
}

Each element is a named list:
\itemize{
\item \code{x}: a H x W x 1 integer array representing an grayscale image.
\item \code{y}: the class id of the image.
}
}
\description{
WHOI-Plankton Dataset
}
\details{
The WHOI-Plankton and WHOI-Plankton small are \strong{image classification} datasets
from the Woods Hole Oceanographic Institution (WHOI) of microscopic marine plankton.
https://hdl.handle.net/10.1575/1912/7341
Images were collected in situ by automated submersible imaging-in-flow cytometry
with an instrument called Imaging FlowCytobot (IFCB). They are small grayscale images
of varying size.
Images are classified into 100 classes, with an overview  available in
\href{https://whoigit.github.io/whoi-plankton/}{project Wiki page}
Dataset size is 957k and 58k respectively, and each provides a train / val / test split.
}
\examples{
\dontrun{
# Load the small plankton dataset and turn images into tensor images
plankton <- whoi_small_plankton_dataset(download = TRUE, transform = transform_to_tensor)

# Access the first item
first_item <- plankton[1]
first_item$x  # a tensor grayscale image with shape {1, H, W}
first_item$y  # id of the plankton class.
plankton$classes[first_item$y] # name of the plankton class

# Load the full plankton dataset
plankton <- whoi_plankton_dataset(download = TRUE)

# Access the first item
first_item <- plankton[1]
first_item$x  # grayscale image array with shape {H, W}
first_item$y  # id of the plankton class.
}

}
\seealso{
Other classification_dataset: 
\code{\link{caltech_dataset}},
\code{\link{cifar10_dataset}()},
\code{\link{eurosat_dataset}()},
\code{\link{fer_dataset}()},
\code{\link{fgvc_aircraft_dataset}()},
\code{\link{flowers102_dataset}()},
\code{\link{image_folder_dataset}()},
\code{\link{lfw_dataset}},
\code{\link{mnist_dataset}()},
\code{\link{oxfordiiitpet_dataset}()},
\code{\link{places365_dataset}()},
\code{\link{tiny_imagenet_dataset}()},
\code{\link{whoi_small_coralnet_dataset}()}
}
\concept{classification_dataset}
