% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDAprep.R
\name{LDAprep}
\alias{LDAprep}
\title{Create Lda-ready Dataset}
\usage{
LDAprep(text, vocab, reduce = TRUE)
}
\arguments{
\item{text}{A list of tokenized texts}

\item{vocab}{A character vector containing all words which should beused for
lda}

\item{reduce}{Logical: Should empty texts be deleted?}
}
\value{
A list in which every entry contains a matrix with two rows: The
first row gives the number of the entry of the word in \code{vocab} minus
one, the second row is 1 and the number of the
occurrence of the word will be shown by the number of columns belonging to
this word.
}
\description{
This function transforms a text corpus such as the result of
\code{\link{cleanTexts}} into the form needed by the \code{\link[lda]{lda}}-package.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

corpus <- cleanTexts(corpus)
wordlist <- makeWordlist(corpus$text)
LDAprep(text=corpus$text, vocab=wordlist$words, reduce = TRUE)

}
\keyword{manip}
