% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{dput2}
\alias{dput2}
\title{Return ASCII representation of an R object}
\usage{
dput2(..., collapse = " ", trim = TRUE)
}
\arguments{
\item{...}{Arguments passed on to \code{\link[=dput]{dput()}}.}

\item{collapse}{Character to use for collapsing the lines.}

\item{trim}{If \code{TRUE}, leading and trailing whitespace from each line is cleared before the lines are collapsed and/or returned.}
}
\value{
If \code{collapse == '\\n'}, a character vector of length 1. Else, a character vector of length \code{n}, where \code{n} corresponds to the number of lines outputted by classic \code{\link[=dput]{dput()}}.
}
\description{
Like classic \code{\link[=dput]{dput()}}, but instead of writing to stdout, the text representation is returned as string.
}
\examples{
# Classic dput prints directly to stdout
x <- iris[1, ]
dput(x)

# Traditional formatting using dput2
y <- dput2(x, collapse = "\n", trim = FALSE)
cat2(y)

# Single line formatting
z <- dput2(x)
cat2(z)
}
\seealso{
\code{\link[=dput]{dput()}}
}
\keyword{base}
