% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{score}
\alias{score}
\title{Internal function to Calculate LOTTR or TTTR Metric Score}
\usage{
score(input_file = NULL, metric, monthly = FALSE, verbose = FALSE)
}
\arguments{
\item{input_file}{Path to file containing travel time readings}

\item{metric}{"LOTTR" or "TTTR"}

\item{monthly}{TRUE or FALSE specifies if the results should be
aggregated by month. If FALSE scores will be computed by TMC for all
data in the input file.}

\item{verbose}{Provide diagnostic output and return all calculated values}
}
\value{
A data.table of LOTTR/TTTR scores by TMC
}
\description{
Calculate LOTTR / TTTR given a RITIS NPMRDS export of travel time data.
Data is passed in as the path to the csv containing the travel time
readings.
input file must have header and format: 
tmc_code,measurement_tstamp,travel_time_seconds
 e.g. 
 > tmc_code,measurement_tstamp,travel_time_seconds
 > 116-04379,2019-01-01 00:00:00,44.78
 > 116-04379,2019-01-01 00:15:00,46.69
}
