rtpt <-
function(n, sigma, lambda, nu)
{
if(is.null(n))
    stop("sample size must be specified")
  if(is.null(sigma))
    stop("sigma must be specified")
  if(is.null(lambda))
    stop("lambda must be specified")
  if(is.null(nu))
    stop("nu must be specified")
  if(n<=0 | round(n)!=n)
    stop("sample size must be a positive integer")      
  if(any(sigma<=0))
    stop("sigma must be positive")
  if(any(nu<=0))
    stop("sigma must be positive")
v=runif(n)
u=runif(n)
sigma*(qt(1+pt(lambda, df=nu)*(v-1), df=nu)+lambda)
}
