% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpwb.R
\name{tpwb}
\alias{tpwb}
\alias{dtpwb}
\alias{ptpwb}
\alias{qtpwb}
\alias{rtpwb}
\title{The three-parameter Weibull distribution(tpwb)}
\usage{
dtpwb(x, shape, scale, location = 1, log = FALSE)

ptpwb(q, shape, scale, location = 1, lower.tail = TRUE, log.p = FALSE)

qtpwb(p, shape, scale, location = 1, lower.tail = TRUE, log.p = FALSE)

rtpwb(n, shape, scale, location = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape}{shape parameter, where \eqn{\beta > 0}.}

\item{scale}{scale parameter, where \eqn{\alpha > 0}.}

\item{location}{location parameter, where \eqn{\delta \ge 0}.}

\item{log, log.p}{logical; (default = \code{FALSE}), if \code{TRUE}, then probabilities are given as \code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dtpwb} gives the density,
\code{ptpwb} gives the distribution function,
\code{qtpwb} gives the quantile function,
and \code{rtpwb} generates random samples.
}
\description{
Density, distribution function, quantile function, and random generation function
for the three-parameter Weibull distribution with \code{shape}, \code{scale} and \code{location}
}
\note{
If location parameter, \eqn{\delta = 0} , it reduced to the two-parameter Weibull distribution.
}
\examples{

x <- rtpwb(20,1.5,3,1)
dtpwb(x,1.5,3,1)
dtpwb(x,1.5,3,1,log=TRUE)

q <- rtpwb(20,1.5,3,1)
ptpwb(q,1.5,3,1 )
ptpwb(q,1.5,3,1, lower.tail = FALSE)

q <- rtpwb(20,1.5,3,1); q
p<- ptpwb(q,1.5,3,1 ); p
qtpwb(p,1.5,3,1)

rtpwb(5, 1.5, 3, 0) # the same as rweibull(5,1.5,3)
rtpwb(25,0.5, 2, 1)

}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 1, chapter 21. Wiley, New York.
}
