% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{fragments}
\alias{fragments}
\title{fragments object}
\description{
An R6 Class representing a fragments object.
}
\details{
This is the parent class of both fragments_trace and fragments_repeats object. The idea is that shared fields and methods are both inherited from this object, but it is not itself directly used.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{unique_id}}{unique id of the sample usually the file name}

\item{\code{metrics_group_id}}{sample grouping for metrics calculations. Associated with \code{add_metadata()}.}

\item{\code{metrics_baseline_control}}{logical to indicate if sample is the baseline control. Associated with \code{add_metadata()}.}

\item{\code{batch_run_id}}{fragment analysis run. Associated with \code{add_metadata()}.}

\item{\code{batch_sample_id}}{An id for the sample used as size standard for repeat calculation. Associated with \code{add_metadata()}.}

\item{\code{batch_sample_modal_repeat}}{Validated repeat length for the modal repeat repeat in that sample. Associated with \code{add_metadata()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-fragments-new}{\code{fragments$new()}}
\item \href{#method-fragments-print}{\code{fragments$print()}}
\item \href{#method-fragments-plot_trace}{\code{fragments$plot_trace()}}
\item \href{#method-fragments-clone}{\code{fragments$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments-new"></a>}}
\if{latex}{\out{\hypertarget{method-fragments-new}{}}}
\subsection{Method \code{new()}}{
initialization function that is not used since the child classes are the main object of this package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments$new(unique_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{unique_id}}{unique_id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments-print"></a>}}
\if{latex}{\out{\hypertarget{method-fragments-print}{}}}
\subsection{Method \code{print()}}{
A function to print informative information to the console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments-plot_trace"></a>}}
\if{latex}{\out{\hypertarget{method-fragments-plot_trace}{}}}
\subsection{Method \code{plot_trace()}}{
plot the trace data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments$plot_trace(
  show_peaks = TRUE,
  x_axis = NULL,
  ylim = NULL,
  xlim = NULL,
  signal_color_threshold = 0.05,
  plot_title = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_peaks}}{A logical to say if the called peaks should be plotted on top of the trace. Only valid for fragments_repeats objects.}

\item{\code{x_axis}}{Either "size" or "repeats" to indicate what should be plotted on the x-axis.}

\item{\code{ylim}}{numeric vector length two specifying the y axis limits}

\item{\code{xlim}}{numeric vector length two specifying the x axis limits}

\item{\code{signal_color_threshold}}{A threshold value to colour the peaks relative to the tallest peak.}

\item{\code{plot_title}}{A character string for setting the plot title. Defaults to the unique id of the object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A base R plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments-clone"></a>}}
\if{latex}{\out{\hypertarget{method-fragments-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
