% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_fragments}
\alias{plot_fragments}
\title{Plot Peak Data}
\usage{
plot_fragments(
  fragments_list,
  n_facet_col = 1,
  sample_subset = NULL,
  xlim = NULL,
  ylim = NULL
)
}
\arguments{
\item{fragments_list}{A list of fragments_repeats objects containing fragment data.}

\item{n_facet_col}{A numeric value indicating the number of columns for faceting in the plot.}

\item{sample_subset}{A character vector of unique ids for a subset of samples to plot}

\item{xlim}{the x limits of the plot. A numeric vector of length two.}

\item{ylim}{the y limits of the plot. A numeric vector of length two.}
}
\value{
A plot object displaying the peak data.
}
\description{
Plots peak data from a list of fragments.
}
\examples{
gm_raw <- trace::example_data

fragments_list <- peak_table_to_fragments(gm_raw,
  data_format = "genemapper5",
  dye_channel = "B",
  min_size_bp = 300
)

find_alleles(
  fragments_list
)

plot_fragments(fragments_list[1])
}
