% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ringPlot.R
\name{ringPlot}
\alias{ringPlot}
\title{Plot intra-ring variation of tracheid features
(with the possibility of plotting a climatic variable)}
\usage{
ringPlot(traq, varMean = NULL, varYear = NULL, m0 = 3, mt = 6.75,
  m1 = 11, type = c("LD", "CWT", "LWratio"), ylab = match.arg(type),
  main = "", addGS = TRUE, addMonths = addGS, ...,
  varMeanCol = "grey80", varYearCol = "red", varName = "")
}
\arguments{
\item{traq}{ordered sequence of a tracheid feature (e.g. LD)}

\item{varMean}{vector with monthly values of a given environmental variable}

\item{varYear}{vector with monlthy values of an environmental variable for a specific year}

\item{m0}{the start of the growing season (in months); the default value is 3 that corresponds to day of the year (doy) 60.}

\item{mt}{the moment of transition from earlywood to latewood; the default value is 6.75.}

\item{m1}{the end of the growing season; default value is 11.}

\item{type}{a string that defines the tracheid features to be plotted, defaults "LD"}

\item{ylab}{the y axis title (for the tracheid feature variable), default value is \code{type}}

\item{main}{an overall title for the plot, if no \code{string} is supplied no title is added to the plot}

\item{addGS}{logical; if \code{TRUE} add the growing season length to the axis 1, defaults \code{TRUE}}

\item{addMonths}{logical; if \code{TRUE} add months to the axis 1, defaults \code{TRUE}}

\item{...}{graphical parameters for \code{plot} may also be passed as arguments to this function}

\item{varMeanCol}{the default value, \code{"grey80"}, gives the color to plot the mean environmental variable}

\item{varYearCol}{the color to plot monthly environmental values; the default value is \code{"red"}}

\item{varName}{the y axis title (for the environmental variable),default value is \code{""}; if no \code{string} is supplied no title is added to environmental axis}
}
\description{
This function plots the intra-ring variation of a tracheid feature (e.g. LD, CWT or LD/CWT)
along the growing season and, optionally, the intra-annual variation of a climatic variable can be added to the same plot.
}
\details{
This function returns an invisible \code{data.frame} (used to produced the graph)
}
\examples{

## Not run:

# year 2010
y2010raw <- getTrac(tch$y2010, scale = .169)
y2010std <- tracheider(y2010raw)
par(oma = c(2,1,1,0.5))
par(mar = c(2,4,1,4))
y2010LD <- ringPlot(traq = y2010std, varMean = colMeans(sw),
varYear = sw["2010",], main=2010,type = "LD",  ylim = c(0,45),
ylab = expression(paste("LD (", mu,"m)")),varName = "Soil moisture")

# year 2013
y2013raw <- getTrac(tch$y2013, scale = .169)
y2013std <- tracheider(y2013raw)
y2013LD <- ringPlot(traq = y2013std, varMean = colMeans(sw),
varYear = sw["2013",], main=2013,type = "LD",  ylim = c(0,45),
ylab = expression(paste("LD (", mu,"m)")),varName = "Soil moisture")

# 2010 & 2013 in the same plot
par(mfcol = c(2,1))
par(oma = c(2,1,1,0.5))
par(mar = c(2,4,1,4))

ringPlot(y2010std,  varMean = colMeans(sw), varYear = sw["2010",],
type = "LD", ylab = "", main=2010, addGS = FALSE, addMonths = FALSE)

ringPlot(y2013std,  varMean = colMeans(sw), varYear = sw["2013",],
type = "LD", ylab=expression(paste("LD (", mu,"m)")),
main = 2013, addGS = TRUE, varName= "Soil moisture")

## End(not run)
}

