% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainR.R
\name{GetArrDepBoardWithDetailsRequest}
\alias{GetArrDepBoardWithDetailsRequest}
\title{Get all public arrivals and departures}
\usage{
GetArrDepBoardWithDetailsRequest(
  crs,
  filterCrs = NA,
  filterType = "from",
  numRows = 150,
  timeOffset = 0,
  timeWindow = 120,
  token = get_token(),
  url = "https://lite.realtime.nationalrail.co.uk/OpenLDBWS/ldb11.asmx",
  verbose = FALSE
)
}
\arguments{
\item{crs}{(string, 3 characters, alphabetic): The CRS code (see above) of
the location for which the request is being made.}

\item{filterCrs}{(string, 3 characters, alphabetic): The CRS code of either
an origin or destination location to filter in. Optional.}

\item{filterType}{(string, either "from" or "to"): The type of filter to
apply. Filters services to include only those originating or terminating
at the \code{filterCrs} location. Defaults to "to".}

\item{numRows}{(integer, between 0 and 150 exclusive): The number of
services to return in the resulting station board.}

\item{timeOffset}{(integer, between -120 and 120 exclusive): An offset in
minutes against the current time to provide the station board for.
Defaults to 0.}

\item{timeWindow}{(integer, between -120 and 120 exclusive): How far into
the future in minutes, relative to \code{timeOffset}, to return services
for. Defaults to 120.}

\item{token}{Token to access the data feed. The token can be obtained at
\url{http://realtime.nationalrail.co.uk/OpenLDBWSRegistration/}.}

\item{url}{Data feed source URL.}

\item{verbose}{Boolean flag to indicate whether or not to show status
messages.}
}
\value{
Tibble with arrival and departure records.
}
\description{
Get all public arrivals and departures for the supplied CRS code within a
defined time window, including service details.
}
\examples{
\dontrun{
rdg<- trainR::GetArrDepBoardWithDetailsRequest("RDG")
rdg <- trainR::GetArrDepBoardWithDetailsRequest("RDG", filterCrs = "BRI")
trainR::print(rdg)
}
}
