% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_intermediate.R
\name{track_intermediate}
\alias{track_intermediate}
\title{Track intermediate points}
\usage{
track_intermediate(x, y, date = NULL, distance = NULL, duration = NULL)
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}

\item{date}{optional input date-time in POSIXct}

\item{distance}{optional minimum distance (metres) between interpolated points}

\item{duration}{optional minimum duration (seconds) between interpolated point,
if set then \code{distance} must be \code{NULL} and \code{date} must be input}
}
\value{
a list of data frames of intermediate points (for use with \code{unnest()} from tidyr)
}
\description{
Calculate great circle intermediate points on longitude, latitude input vectors. A
spherical model is used, from the geosphere package.
}
\details{
This function returns a list of data frames, with a data frame of interpolated locations
for every interval between input locations. There is a final empty data frame to ensure
the list is the same length as the inputs. See embedded usage of the tidyr function 'unnest()'
for ease of use.

To use on multiple track ids, use a grouped data frame with tidyverse code like
\verb{inter <- data \%>\% group_by(id) \%>\% mutate(inter = track_intermediate(lon, lat, date = , distance = )}.

Then, un-nest this result for further use (the 'inter' above retains the information
about the parent locations for custom usage if needed), so the final location of each
group has invalid intermediates:
\code{dd <- inter \%>\% slice(-1) \%>\% unnest()}
}
\examples{
track_intermediate(trips0$x[1:10], trips0$y[1:10], distance = 15000)

track_intermediate(trips0$x[1:10], trips0$y[1:10], date = trips0$date,
                                 distance = 1500)

inter_time <- track_intermediate(trips0$x[1:10], trips0$y[1:10],
                            date = trips0$date, duration = 1800)
}
