% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conc2frac.R
\name{conc2frac}
\alias{conc2frac}
\title{Creates a data frame as a complete self-contained transport data set}
\usage{
conc2frac(feed, strip, time = NULL, correct.strip = FALSE, normalize = TRUE)
}
\arguments{
\item{feed}{Numeric vector with concentrations in the feed phase.}

\item{strip}{Numeric vector with concentrations in the strip phase.}

\item{time}{Numeric vector with time at which the aliquots were
sampled. It is an optional parameter. If not provided,
regular unitary time intervals are assumed.}

\item{correct.strip}{Logical. If \code{FALSE}, the default, the information
about the amount transported to the strip phase is used
as received but if it is set to \code{TRUE}, the
initial concentration in the strip phase is substracted
to all concentrations in the same phase. This is
particularly useful when the blank signal is
significative or there is background noise.}

\item{normalize}{Logical. If \code{TRUE}, the default, all
concentrations are divided by the initial concentration
in the feed phase to give results in fraction units.}
}
\value{
Data frame with the transport proccess information
}
\description{
The function transforms the data contained in concentration vectors of
feed and strip phases to a data frame that contains the complete data
of a transport process. This new data frame can be used by several functions
inside the package. The output data frame may contain normalized fractions
remaining in the feed and already transported to the strip phase, or the
original data provided in concentration units.
}
\details{
The change in concentration of species in the feed and strip phases as a
function of time are the main magnitudes being measured in processes
involving transport across membranes. The best form to deal with such data
is inside a dataframe containing the information about the concentration
of given species in both phases and the time transcurred.

Usually, this function is required after using \code{\link{signal2conc}}
wich convert instrumental signals to concentrations.
}
\examples{
  transData <- conc2frac(feed = c(0.200, 0.169, 0.152, 0.141, 0.138),
                         strip = c(0.000, 0.035, 0.045, 0.062, 0.069),
                         time = c(0, 2, 4, 6, 8))
  print(transData)
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
