% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal2conc.R
\name{signal2conc}
\alias{signal2conc}
\title{Converts signals into concentration by using given model.}
\usage{
signal2conc(signal, model, dilution = NULL, planar = FALSE, Conc.S = NULL)
}
\arguments{
\item{signal}{Numeric vector of signals to be interpolated.}

\item{model}{Regression model of the calibration. Must be obtained
using \code{\link{calibCurve}} or \code{\link{calibPlane}}.}

\item{dilution}{Numeric vector of dilution factors applied to samples
before measurement}

\item{planar}{Logical, default to \code{FALSE}. It must be set to TRUE if
more than one explanatory variable is used. A planar
calibration model must be provided to \code{model}
parameter.}

\item{Conc.S}{Numeric vector of the concentrations of the interferent
species to be considered when a planar calibration model is
provided to \code{model}. It is taken into account if
\code{planar = TRUE}.}
}
\value{
Numeric vector of species concentrations.
}
\description{
After a calibration model is established (either by using
\code{\link{calibCurve}} or \code{\link{calibPlane}}), the function
interpolates the signals of samples to get the associated concentrations.
}
\examples{
  # A regression model is needed:
  data(curvelithium)
  model <- calibCurve(curve = curvelithium, order = 2)

  signal <- c(0.395, 0.259, 0.188, 0.141, 0.110, 0.095, 0.084)
  (conc <- signal2conc(signal = signal, model = model))
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
