% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukkri.R
\name{ukkdri_q}
\alias{ukkdri_q}
\title{UK Kidney Donor Risk Index Quartile (2019)}
\usage{
ukkdri_q(dri, prefix = FALSE, fct = FALSE)
}
\arguments{
\item{dri}{numeric vector of UKKDRI values}

\item{prefix}{whether to prefix results with "D" (default FALSE)}

\item{fct}{whether to return results as a factor (default FALSE)}
}
\value{
vector of UKKDRI quartiles
}
\description{
Vectorised function to convert UKKDRI values to quartiles of risk. The function takes a numeric
vector of UKKDRI values as input, and returns a vector of quartiles. By default this is also a
numeric vector with values 1-4, but this can be changed to a character string vector of D1-D4 to
match the nomenclature in the NHSBT ODT documentation by setting the prefix parameter to TRUE. The
output can also be as a vector of factors by setting fct to TRUE (this can be combined with the
prefix parameter).
}
\details{
The UK KDRI quartile ranges are documented in the UK kidney matching policy which can be found
on the NHS Blood & Transplant ODT website at www.odt.nhs.uk
}
\examples{
# obtain quartile of a single value
ukkdri_q(1.01)

# factor vector of results with prefix
dri = c(0.69, 1.01, 1.36, 1.54)
ukkdri_q(dri, prefix = TRUE, fct = TRUE)
}
