% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukkri.R
\name{watson_ukkdri}
\alias{watson_ukkdri}
\title{UK Kidney Donor Risk Index (2012 version)}
\usage{
watson_ukkdri(age, htn, weight, hdays, adrenaline)
}
\arguments{
\item{age}{numeric vector of donor ages}

\item{htn}{numeric vector of whether donor history of hypertension (1 = yes, 0 = no)}

\item{weight}{numeric vector of donor weights in kg}

\item{hdays}{numeric vector of donor length of hospital stay}

\item{adrenaline}{numeric vector of whether donor treated with adrenaline (1 = yes, 0 = no)}
}
\value{
numeric vector of UK Kidney Donor Risk Index (2012) values
}
\description{
A vectorised function to calculate the UK Kidney Donor Risk Index as published by Watson et al.
in 2012. Please note that this is not the same risk index as used in the new UK kidney
matching scheme starting in September 2019.
}
\details{
Reference: Watson CJE, Johnson RJ, Birch R, et al. A Simplified Donor Risk Index for Predicting
Outcome After Deceased Donor Kidney Transplantation. Transplantation 2012; 93(3):314-318
}
\examples{
watson_ukkdri(age = 40, htn = 0, weight = 75, hdays = 0, adrenaline = 0) # 1.00
}
