% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-root-power.R
\name{root}
\alias{root}
\alias{root_sq}
\alias{root_cubic}
\title{nth Root Transformation}
\usage{
root(x, root = NULL, modulus = FALSE)

root_sq(x, ...)

root_cubic(x, ...)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{root}{\verb{[numeric(1): NA]}

The nth root.}

\item{modulus}{\verb{[logical(1): FALSE]}

Transformation will work for data with both positive and negative \code{root}.}

\item{...}{Further arguments passed to \code{root}.}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}
\itemize{
\item \code{root}: nth root
\item \code{root_sqrt}: square root
\item \code{root_cubic}: cubic root
}
}
\examples{

root(4, 2)
root(-4, 2)

root(-4, 2, TRUE)
}
