% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitTrawlFunctions.R
\name{fit_LMtrawl}
\alias{fit_LMtrawl}
\title{Fits a long memory trawl function to equidistant univariate time series data}
\usage{
fit_LMtrawl(x, Delta = 1, GMMlag = 5, plotacf = FALSE, lags = 100)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{GMMlag}{lag length used in the GMM estimation, the default is 5}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
alpha: parameter in the long memory trawl

H: parameter in the long memory trawl

LM: The Lebesgue measure of the trawl set associated with the
long memory  trawl
}
\description{
Fits a long memory trawl function to equidistant univariate time series data
}
\details{
The trawl function is parametrised by the two parameters \eqn{H> 1}
 and \eqn{\alpha > 0} as follows: \deqn{g(x) = (1-x/\alpha)^{-H},\mbox{ for }
 x \le  0.} The Lebesgue measure of the corresponding trawl set is given by
 \eqn{\alpha/(1-H)}.
}
