% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{trees}
\alias{trees}
\title{Angle Count Sampling of the German National Inventory 2022}
\format{
A data frame with 1121 observations on the following 9 variables.
Variables not needed with the package are marked with an asterisk.
  \describe{
    \item{\code{tnr}}{The tract id.}
    \item{\code{enr}}{The corner id. A tract may have up to 4 corners on
    wooden floor.}
    \item{\code{bnr}}{The tree id.}
    \item{\code{bhd2}}{The diameter at breast height, given in centimeter}.
    \item{\code{kf2}}{* The correction factor given by \command{grenzkreis}}.
    \item{\code{entf}}{The trees' distance from the center of the tract's
    corner, given in meter.}
    \item{\code{azi}}{The azimuth from North, measured in gon (or gradian).}
    \item{\code{pk}}{* An indicator giving the type of a tree in the German
    national forest inventory. 0 marks ingrowth, 1 marks ongrowth.}
    \item{\code{stp}}{* An indicator giving the type of sample the tree was
    in. 0 marks the angle count sample with counting factor 4.}
  }
}
\usage{
data("trees", package = "treePlotArea")
}
\description{
This is an extract form a data set prepared by Gerald Kaendler.
He
\enumerate{
    \item added trees that are not part of the angle count sampling,
    \item converted the diameter at breast height from millimeter to
    centimeter and renamed it,
    \item converted horizontal distance from centimeter to meter and renamed
    it,
    \item computed correction factors using \command{grenzkreis}.
}
}
\examples{
trees <- get(data("trees", package = "treePlotArea"))
summary(trees)
angle_counts <- bw2bwi2022de(trees)
summary(angle_counts)
}
\keyword{datasets}
