% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fit.R
\name{get_fit}
\alias{get_fit}
\alias{get_fit.default}
\alias{get_fit.partynode}
\alias{get_fit.party}
\alias{get_fit.data.frame}
\title{------------------------------------------------------------------------------------
Get the fitted tree depending on the input `x`.}
\usage{
get_fit(x, ...)

\method{get_fit}{default}(x, ...)

\method{get_fit}{partynode}(x, data_test, target_lab, ...)

\method{get_fit}{party}(x, data_test, target_lab, task, ...)

\method{get_fit}{data.frame}(x, data_test, target_lab, ...)
}
\arguments{
\item{x}{Dataframe or a `party` or `partynode` object representing a custom tree.
If a dataframe is supplied, conditional inference tree is computed.
If a custom tree is supplied, it must follow the partykit syntax:
https://cran.r-project.org/web/packages/partykit/vignettes/partykit.pdf}

\item{\dots}{Further arguments passed to each method.}

\item{data_test}{Tidy test dataset. Required if `x` is a `partynode` object.
If NULL, heatmap displays (training) data `x`.}

\item{target_lab}{Name of the column in data that contains target/label information.}

\item{task}{Character string indicating the type of problem,
either 'classification' (categorical outcome) or 'regression' (continuous outcome).}
}
\value{
Fitted object as a list with prepped `data_test` if available.
}
\description{
If `x` is a data.frame object, computes conditional tree from partkit::ctree().
If `x` is a partynode object specifying the customized tree, fit `x` on `data_test`.
If `x` is a party (or constparty) object specifying the precomputed tree, simply coerce
`x` to have class constparty.
}
