% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-first-child-byte}
\alias{node-first-child-byte}
\alias{node_first_child_for_byte}
\alias{node_first_named_child_for_byte}
\title{Get the first child that extends beyond the given byte offset}
\usage{
node_first_child_for_byte(x, byte)

node_first_named_child_for_byte(x, byte)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}

\item{byte}{\verb{[integer(1)]}

The byte to start the search from.

Note that \code{byte} is 0-indexed!}
}
\value{
A new node, or \code{NULL} if there is no node past the \code{byte} offset.
}
\description{
These functions return the first child of \code{x} that extends beyond the given
\code{byte} offset. Note that \code{byte} is a 0-indexed offset.
\itemize{
\item \code{node_first_child_for_byte()} considers both named and anonymous nodes.
\item \code{node_first_named_child_for_byte()} considers only named nodes.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Navigate to first child
node <- node_child(node, 1)
node

# `fn {here}<- function()`
node_first_child_for_byte(node, 3)
node_first_named_child_for_byte(node, 3)

# Past any node
node_first_child_for_byte(node, 100)
\dontshow{\}) # examplesIf}
}
