% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{accessors}
\alias{accessors}
\alias{get_result}
\alias{get_result.default}
\alias{get_result.trending_fit}
\alias{get_result.trending_predict}
\alias{get_result.trending_fit_tbl}
\alias{get_result.trending_predict_tbl}
\alias{get_warnings}
\alias{get_warnings.default}
\alias{get_warnings.trending_fit}
\alias{get_warnings.trending_predict}
\alias{get_warnings.trending_fit_tbl}
\alias{get_warnings.trending_predict_tbl}
\alias{get_errors}
\alias{get_errors.default}
\alias{get_errors.trending_fit}
\alias{get_errors.trending_predict}
\alias{get_errors.trending_fit_tbl}
\alias{get_errors.trending_predict_tbl}
\alias{get_fitted_model}
\alias{get_fitted_model.default}
\alias{get_fitted_model.trending_fit}
\alias{get_fitted_model.trending_fit_tbl}
\alias{get_fitted_data}
\alias{get_fitted_data.default}
\alias{get_fitted_data.trending_fit}
\alias{get_fitted_data.trending_fit_tbl}
\alias{get_formula}
\alias{get_formula.default}
\alias{get_formula.trending_model}
\alias{get_formula.tranding_model}
\alias{get_formula.trending_fit}
\alias{get_formula.tranding_fit}
\alias{get_formula.trending_fit_tbl}
\alias{get_response}
\alias{get_response.default}
\alias{get_response.trending_model}
\alias{get_response.trending_fit}
\alias{get_response.trending_fit_tbl}
\alias{get_response.trending_prediction}
\alias{get_response.trending_predict}
\alias{get_response.trending_predict_tbl}
\alias{get_predictors}
\alias{get_predictors.default}
\alias{get_predictors.trending_model}
\alias{get_predictors.trending_fit}
\alias{get_predictors.trending_fit_tbl}
\alias{get_predictors.trending_prediction}
\alias{get_predictors.trending_predict}
\alias{get_predictors.trending_predict_tbl}
\alias{get_estimate}
\alias{get_estimate.default}
\alias{get_estimate.trending_prediction}
\alias{get_estimate.trending_predict}
\alias{get_estimate.trending_predict_tbl}
\title{Accessors generics}
\usage{
get_result(x, ...)

\method{get_result}{default}(x, ...)

\method{get_result}{trending_fit}(x, ...)

\method{get_result}{trending_predict}(x, ...)

\method{get_result}{trending_fit_tbl}(x, ...)

\method{get_result}{trending_predict_tbl}(x, ...)

get_warnings(x, ...)

\method{get_warnings}{default}(x, ...)

\method{get_warnings}{trending_fit}(x, ...)

\method{get_warnings}{trending_predict}(x, ...)

\method{get_warnings}{trending_fit_tbl}(x, ...)

\method{get_warnings}{trending_predict_tbl}(x, ...)

get_errors(x, ...)

\method{get_errors}{default}(x, ...)

\method{get_errors}{trending_fit}(x, ...)

\method{get_errors}{trending_predict}(x, ...)

\method{get_errors}{trending_fit_tbl}(x, ...)

\method{get_errors}{trending_predict_tbl}(x, ...)

get_fitted_model(x, ...)

\method{get_fitted_model}{default}(x, ...)

\method{get_fitted_model}{trending_fit}(x, ...)

\method{get_fitted_model}{trending_fit_tbl}(x, ...)

get_fitted_data(x, ...)

\method{get_fitted_data}{default}(x, ...)

\method{get_fitted_data}{trending_fit}(x, ...)

\method{get_fitted_data}{trending_fit_tbl}(x, ...)

get_formula(x, ...)

\method{get_formula}{default}(x, ...)

\method{get_formula}{trending_model}(x, ...)

\method{get_formula}{trending_fit}(x, ...)

\method{get_formula}{trending_fit_tbl}(x, ...)

get_response(x, ...)

\method{get_response}{default}(x, ...)

\method{get_response}{trending_model}(x, ...)

\method{get_response}{trending_fit}(x, ...)

\method{get_response}{trending_fit_tbl}(x, ...)

\method{get_response}{trending_prediction}(x, ...)

\method{get_response}{trending_predict}(x, ...)

\method{get_response}{trending_predict_tbl}(x, ...)

get_predictors(x, ...)

\method{get_predictors}{default}(x, ...)

\method{get_predictors}{trending_model}(x, ...)

\method{get_predictors}{trending_fit}(x, ...)

\method{get_predictors}{trending_fit_tbl}(x, ...)

\method{get_predictors}{trending_prediction}(x, ...)

\method{get_predictors}{trending_predict}(x, ...)

\method{get_predictors}{trending_predict_tbl}(x, ...)

get_estimate(x, ...)

\method{get_estimate}{default}(x, ...)

\method{get_estimate}{trending_prediction}(x, ...)

\method{get_estimate}{trending_predict}(x, ...)

\method{get_estimate}{trending_predict_tbl}(x, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{Not currently used by any methods.}
}
\value{
\itemize{
\item \code{get_result()}: the captured output.
\item \code{get_warnings()}: the captured warnings.
\item \code{get_errors()}: the captured warnings.
\item \code{get_fitted_data}: The underlying data used to fit the model.
\item \code{get_fitted_model()}: The underlying fitted model.
\item \code{get_formula()}: the formula used to model temporal trends.
\item \code{get_response()}: the response variable of the underlying model.
\item \code{get_predictors()}: the predictor variable(s) of the underlying model.
}
}
\description{
Generics for accessing model information.
}
\details{
Methods are provided for  \code{trending_model}, \code{trending_fit},
\code{trending_fit_tbl}, \code{trending_predict}, and \code{trending_predict_tbl} objects.
}
\examples{
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)
poisson_model <- glm_model(y ~ x , family = "poisson")
fitted_poisson <- fit(poisson_model, dat)

get_fitted_model(fitted_poisson)
get_formula(fitted_poisson)
get_response(fitted_poisson)
get_predictors(fitted_poisson)

}
