% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{list_datasets}
\alias{list_datasets}
\title{List Available Datasets}
\usage{
list_datasets()
}
\value{
A tibble with the following columns:
\describe{
\item{name}{Dataset name}
\item{description}{Brief description of the dataset}
\item{frequency}{Data frequency (D = daily, M = monthly, Q = quarterly)}
\item{n_obs}{Number of observations}
\item{first_date}{First observation date}
\item{last_date}{Last observation date}
\item{value_cols}{Main value column(s) in the dataset}
\item{source}{Data source}
}
}
\description{
Returns a tibble with metadata for all datasets included in the trendseries package.
}
\examples{
# List all available datasets
list_datasets()

# Filter for monthly data
list_datasets() |>
  dplyr::filter(frequency == "M")

}
