% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_value_type.R
\encoding{UTF-8}
\name{infer_value_type}
\alias{infer_value_type}
\title{Infer variable type from numeric vector / Typ-Erkennung numerischer Vektoren}
\usage{
infer_value_type(values, verbose = TRUE, thresholds = NULL)
}
\arguments{
\item{values}{A numeric vector<br>Ein numerischer Vektor}

\item{verbose}{Logical, whether to show warnings (default TRUE)<br>Gibt an, ob Warnmeldungen angezeigt werden (Standard: TRUE)}

\item{thresholds}{Optional list of numeric thresholds for type detection (for internal use only)<br>Optionale Liste von Schwellwerten zur Typ-Erkennung (nur intern verwendet)}
}
\value{
A character string indicating the inferred type: "binary", "proportion", "count", "discrete", or "continuous".<br>
Ein Zeichenstring mit dem erkannten Typ: "binary", "proportion", "count", "discrete" oder "continuous".
}
\description{
This function analyzes a numeric vector and infers the underlying variable type:
"binary", "proportion", "count", "discrete", or "continuous".
Useful for selecting statistical tests or visualization strategies.
}
\details{
Diese Funktion analysiert einen numerischen Vektor und erkennt den zugrunde liegenden Typ:
"binary", "proportion", "count", "discrete" oder "continuous".
Nützlich zur Auswahl geeigneter statistischer Tests oder Visualisierungen.
}
\examples{
infer_value_type(c(1, 0, 1, 1))
infer_value_type(c(0.2, 0.5, 0.8))
infer_value_type(c(3, 4, 6, 1000000))

}
\seealso{
[standardize_case_columns()]
}
