% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_efftox_priors.R
\name{get_efftox_priors}
\alias{get_efftox_priors}
\title{Get normal prior hyperparameters for the EffTox model.}
\usage{
get_efftox_priors(
  doses = NULL,
  scaled_doses = NULL,
  pi_T,
  ess_T,
  pi_E,
  ess_E,
  num_samples = 10^4,
  seed = 123
)
}
\arguments{
\item{doses}{A vector of numbers, the doses under investigation. They
should be ordered from lowest to highest and be in consistent units.
E.g. to conduct a dose-finding trial of doses 10mg, 20mg and 50mg, use
c(10, 20, 50). Specify \code{doses} or \code{scaled_doses}.}

\item{scaled_doses}{Optional, vector of numbers, representing the scaled
doses under investigation. Thall et al. advocate
\code{scaled_doses = log(doses) - mean(log(doses))}, and that is what we use
here. Specify \code{doses} or \code{scaled_doses}.}

\item{pi_T}{Vector of prior expectations of probabilities of toxicity at the
doses. Should be congruent to \code{doses} or \code{scaled_doses}.}

\item{ess_T}{Numerical, sought total effective sample size for priors on
parameters in the toxicity sub-model. Thall et al. (2014) advocate values in
(0.3, 1.0) but stress that stress-testing with values outside this range may
be necessary.}

\item{pi_E}{Vector of prior expectations of probabilities of efficacy at the
doses. Should be congruent to \code{doses} or \code{scaled_doses}.}

\item{ess_E}{Numerical, sought total effective sample size for priors on
parameters in the efficacy sub-model. Thall et al. (2014) advocate values in
(0.3, 1.0) but stress that stress-testing with values outside this range may
be necessary.}

\item{num_samples}{Number of samples to draw from priors. The default 10^4
seems to be a nice compromise between accuracy and speed. Orders of magnitude
larger take a long time to run.}

\item{seed}{Optional seed. This process involves randomness so seeds are used
for repeatable results.}
}
\value{
An instance of class \code{\link{efftox_priors}}.
}
\description{
Get normal prior hyperparameters for the EffTox model using the algorithm
presented in Thall et al. (2014) that targets a family of priors with a
pre-specified effective sample size (ESS).
}
\examples{
\dontrun{
# Reproduce the priors calculated in Thall et al. (2014)
p <- get_efftox_priors(
  doses = c(1.0, 2.0, 4.0, 6.6, 10.0),
  pi_T = c(0.02, 0.04, 0.06, 0.08, 0.10), ess_T = 0.9,
  pi_E = c(0.2, 0.4, 0.6, 0.8, 0.9), ess_E = 0.9
)
p
# These are close to the published example. They do not match exactly because
# the process of deriving them is iterative.
}
}
\references{
Thall, P., Herrick, R., Nguyen, H., Venier, J., & Norris, J. (2014).
    Effective sample size for computing prior hyperparameters in Bayesian
    phase I-II dose-finding. Clinical Trials, 11(6), 657-666.
    https://doi.org/10.1177/1740774514547397
}
