% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-plots.R
\name{qqtriangle}
\alias{qqtriangle}
\title{Quantile-Quantile Plot for Triangle Distributed Data}
\usage{
qqtriangle(
  y,
  a,
  b,
  c,
  main = "Triangle Q-Q Plot",
  xlab = "Theoretical Quantiles",
  ylab = "Sample Quantiles",
  ...
)
}
\arguments{
\item{y}{the triangle distributed sample}

\item{a}{the theoretical distribution triangle minimum parameter}

\item{b}{the theoretical distribution triangle maximum parameter}

\item{c}{the theoretical distribution triangle mode parameter}

\item{main}{the plot title}

\item{xlab}{the x-axis label}

\item{ylab}{the y-axis label}

\item{...}{other parameters passed to \code{qqplot}}
}
\value{
a list of x-y coordinates on the plot
}
\description{
Quantile-Quantile Plot for Triangle Distributed Data
}
\examples{
set.seed(10304)
xtest <- rtriangle(100, 1, 5, 2)
theta <- coef(triangle_mle(xtest))
qqtriangle(xtest, theta[1], theta[2], theta[3])
}
