% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfe.R
\name{triangle_cdfe}
\alias{triangle_cdfe}
\title{Triangle parameter estimates using a non-linear fit of the empirical CDF}
\usage{
triangle_cdfe(x, control = stats::nls.control(maxiter = 100, warnOnly = TRUE))
}
\arguments{
\item{x}{the triangle distributed sample}

\item{control}{an object created by \code{stats::nls.control}}
}
\value{
an object of class \code{nls}
}
\description{
Triangle parameter estimates using a non-linear fit of the empirical CDF
}
\examples{
set.seed(10304)
xtest <- rtriangle(100, 1, 5, 2)
cdfe <- triangle_cdfe(xtest)
print(cdfe)
summary(cdfe)
coef(cdfe)
\dontrun{
  confint(cdfe)
}
}
