% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_position.R
\name{determine_position}
\alias{determine_position}
\title{Determine position of observer}
\usage{
determine_position(A, B, C, observer_angle_AB, observer_angle_AC,
  observer_angle_BC = NA, output_plot = TRUE, lines_in_plot = TRUE,
  coordinates_in_plot = TRUE, decimals_in_plot = 2)
}
\arguments{
\item{A}{A point defined by a vector containing an x- and an y-coordinate}

\item{B}{A point defined by a vector containing an x- and an y-coordinate}

\item{C}{A point defined by a vector containing an x- and an y-coordinate}

\item{observer_angle_AB}{An angle (numeric) expressed in radians (or alternatively the symbol \code{NA})}

\item{observer_angle_AC}{An angle (numeric) expressed in radians (or alternatively the symbol \code{NA})}

\item{observer_angle_BC}{An angle (numeric) expressed in radians (or alternatively the symbol \code{NA})}

\item{output_plot}{Boolean variable indicating whether a plot should be created}

\item{lines_in_plot}{Boolean variable indicating whether lines should be drawn in the plot}

\item{coordinates_in_plot}{Boolean variable indicating whether the coordinates should be printet in the plot}

\item{decimals_in_plot}{Integer indicating the number of decimals used}
}
\value{
Coordinates indicating the observers position. Note that several solutions might exist.
}
\description{
Determine the position of an observer based on angles between three known points as seen by the observer.
At least two angles must be provided - preferably \code{observer_angle_AB} and \code{observer_angle_AC}
(since this combination allows for solutions outside the triangle formed by the points \code{A}, \code{B} and \code{C})
}
\examples{
determine_position(A = c(0, 0), B = c(10, 0), C = c(5, 5 * 3^0.5), observer_angle_AB = pi * 2/3,
observer_angle_AC = pi * 1/2)

determine_position(A = c(0, 0), B = c(10, 0), C = c(5, 5), observer_angle_AB = pi * 5/6,
observer_angle_AC = pi * 1/2, observer_angle_BC = NA, lines_in_plot = FALSE)

determine_position(A = c(0, 0), B = c(10, 0), C = c(5, 5), observer_angle_AB = pi * 5/6,
observer_angle_AC = pi * 1/2, observer_angle_BC = pi * 2/3, lines_in_plot = FALSE)
}

