% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_region.R
\name{determine_region}
\alias{determine_region}
\title{Determine confidence region for position}
\usage{
determine_region(A, B, C, observer_angle_AB, observer_angle_AC,
  angle_error = pi/24, number_of_points = 200, output_plot = TRUE,
  lines_in_plot = FALSE, coordinates_in_plot = FALSE,
  decimals_in_plot = 2)
}
\arguments{
\item{A}{A point defined by a vector containing an x- and an y-coordinate}

\item{B}{A point defined by a vector containing an x- and an y-coordinate}

\item{C}{A point defined by a vector containing an x- and an y-coordinate}

\item{observer_angle_AB}{An angle (numeric) expressed in radians}

\item{observer_angle_AC}{An angle (numeric) expressed in radians}

\item{angle_error}{A numeric indicating the measurement error in radians}

\item{number_of_points}{A numeric indicating the number of error points tested}

\item{output_plot}{Boolean variable indicating whether a plot should be created}

\item{lines_in_plot}{Boolean variable indicating whether lines should be drawn in the plot}

\item{coordinates_in_plot}{Boolean variable indicating whether the coordinates should be printet in the plot}

\item{decimals_in_plot}{Integer indicating the number of decimals used}
}
\value{
Coordinates indicating the outer border of the confidence region. Note that several different regions may exist.
}
\description{
This function is similar to \code{determine_position()}except for the fact that it is assumed that the angles are subject to measurement error.
Hence a confidence region (error 'ellipse') is returned instead of an exact position.
}
\examples{
determine_region(A = c(0, 0), B = c(10, 0), C = c(5, 5 * 3^0.5), observer_angle_AB = pi * 2/3,
observer_angle_AC = pi * 1/2)

determine_region(A = c(0, 0), B = c(10, 0), C = c(5, 5), observer_angle_AB = pi * 5/6,
observer_angle_AC = pi * 1/2, lines_in_plot = FALSE)
}

