% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridRecursive.R
\name{hybridRecursive}
\alias{hybridRecursive}
\title{hybridRecursive trimming procedure.}
\usage{
hybridRecursive(
  data,
  minRT,
  pptVar = "participant",
  condVar = "condition",
  rtVar = "rt",
  accVar = "accuracy",
  omitErrors = TRUE,
  digits = 3
)
}
\arguments{
\item{data}{A data frame with columns containing: participant identification
number ('pptVar'); condition identification, if applicable ('condVar');
response time data ('rtVar'); and accuracy ('accVar'). The RT can be in
seconds (e.g., 0.654) or milliseconds (e.g., 654). Typically, "condition"
will consist of strings. Accuracy must be coded as 1 for correct and 0 for
error responses.}

\item{minRT}{The lower criteria for acceptable response time. Must be in
the same form as rt column in data frame (e.g., in seconds OR milliseconds).
All RTs below this value are removed before proceeding with SD trimming.}

\item{pptVar}{The quoted name of the column in the data that identifies
participants.}

\item{condVar}{The quoted name of the column in the data that includes the
conditions.}

\item{rtVar}{The quoted name of the column in the data containing reaction
times.}

\item{accVar}{The quoted name of the column in the data containing accuracy,
coded as 0 or 1 for incorrect and correct trial, respectively.}

\item{omitErrors}{If set to TRUE, error trials will be removed before
conducting trimming procedure. Final data returned will not be influenced
by errors in this case.}

\item{digits}{How many decimal places to round to after trimming?}
}
\description{
\code{hybridRecursive} takes a data frame of RT data and returns trimmed rt
data. The returned value is the average returned from the nonRecursive
and the modifiedRecursive procedures  as described in van Selst &
Jolicoeur (1994).
}
\examples{
# load the example data that ships with trimr
data(exampleData)

# perform the trimming, returning mean RT
trimmedData <- hybridRecursive(data = exampleData, minRT = 150)

}
\references{
Van Selst, M. & Jolicoeur, P. (1994). A solution to the effect
of sample size on outlier elimination. \emph{Quarterly Journal of Experimental
Psychology, 47} (A), 631-650.
}
