% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R, R/triptych_mcbdsc.R,
%   R/triptych_murphy.R, R/triptych_reliability.R, R/triptych_roc.R
\name{estimates}
\alias{estimates}
\alias{estimates.triptych_mcbdsc}
\alias{estimates.triptych_murphy}
\alias{estimates.triptych_reliability}
\alias{estimates.triptych_roc}
\title{Accessing diagnostic estimate data}
\usage{
estimates(x, at, ...)

\method{estimates}{triptych_mcbdsc}(x, ...)

\method{estimates}{triptych_murphy}(x, at = NULL, ...)

\method{estimates}{triptych_reliability}(x, at = NULL, ...)

\method{estimates}{triptych_roc}(x, at = NULL, p1 = mean(observations(x)), ...)
}
\arguments{
\item{x}{An object from which the estimate information should be extracted.}

\item{at}{A vector of thresholds where \code{x} should be evaluated.}

\item{...}{Additional arguments passed to other methods.}

\item{p1}{The unconditional event probability. Used in combination with \code{at}
to determine the diagonal lines along which to determine the estimate.}
}
\value{
A tibble with the relevant information describing
the diagnostic estimate
(Murphy curve, reliability curve, ROC curve, score decomposition)
for all supplied forecasting methods.

For a Murphy curve, a tibble with columns: \code{forecast}, \code{knot} (the threshold value), \code{limit} ("left" or "right" in \code{knot}, only present if \code{at = NULL}), \code{mean_score}.

For a reliability curve, a tibble with columns: \code{forecast}, \code{CEP}, \code{x} (the knots of the isotonic regression estimate).

For a ROC curve, a tibble with columns: \code{forecast}, \code{FAR} (false alarm rate), \code{HR} (hit rate).

For a MCBDSC decomposition, a tibble with columns: \code{forecast}, \code{mean_score}, \code{MCB} (miscalibration), \code{DSC} (discrimination), \code{UNC} (uncertainty).
}
\description{
Accessing diagnostic estimate data
}
\examples{
data(ex_binary, package = "triptych")
tr <- triptych(ex_binary)

estimates(tr$murphy)
estimates(tr$reliability)
estimates(tr$roc)
estimates(tr$mcbdsc)

}
\seealso{
\code{\link[=regions]{regions()}}, \code{\link[=forecasts]{forecasts()}}, \code{\link[=observations]{observations()}}
}
