% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsegest.R
\name{tsegest}
\alias{tsegest}
\title{Two-Stage Estimation with g-Estimation (TSEgest) for Treatment
Switching}
\usage{
tsegest(
  data,
  id = "id",
  stratum = "",
  tstart = "tstart",
  tstop = "tstop",
  event = "event",
  treat = "treat",
  censor_time = "censor_time",
  pd = "pd",
  pd_time = "pd_time",
  swtrt = "swtrt",
  swtrt_time = "swtrt_time",
  base_cov = "",
  conf_cov = "",
  strata_main_effect_only = TRUE,
  ns_df = 3,
  firth = FALSE,
  flic = FALSE,
  low_psi = -2,
  hi_psi = 2,
  n_eval_z = 101,
  recensor = TRUE,
  admin_recensor_only = TRUE,
  swtrt_control_only = TRUE,
  gridsearch = TRUE,
  root_finding = "brent",
  alpha = 0.05,
  ties = "efron",
  tol = 1e-06,
  offset = 1,
  boot = TRUE,
  n_boot = 1000,
  seed = NA
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{id}: The id to identify observations belonging to the same
subject for counting process data with time-dependent covariates.
\item \code{stratum}: The stratum.
\item \code{tstart}: The starting time of the time interval for
counting-process data with time-dependent covariates.
\item \code{tstop}: The stopping time of the time interval for
counting-process data with time-dependent covariates.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{treat}: The randomized treatment indicator, 1=treatment,
0=control.
\item \code{censor_time}: The administrative censoring time. It should
be provided for all subjects including those who had events.
\item \code{pd}: The disease progression indicator, 1=PD, 0=no PD.
\item \code{pd_time}: The time from randomization to disease progression.
\item \code{swtrt}: The treatment switch indicator, 1=switch, 0=no switch.
\item \code{swtrt_time}: The time from randomization to treatment switch.
\item \code{base_cov}: The baseline covariates (excluding treat).
\item \code{conf_cov}: The confounding variables (excluding treat) for
predicting treatment switching.
}}

\item{id}{The name of the id variable in the input data.}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{tstart}{The name of the tstart variable in the input data.}

\item{tstop}{The name of the tstop variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{censor_time}{The name of the censor_time variable in the input data.}

\item{pd}{The name of the pd variable in the input data.}

\item{pd_time}{The name of the pd_time variable in the input data.}

\item{swtrt}{The name of the swtrt variable in the input data.}

\item{swtrt_time}{The name of the swtrt_time variable in the input data.}

\item{base_cov}{The names of baseline covariates (excluding
treat) in the input data for the Cox model.}

\item{conf_cov}{The names of confounding variables (excluding
treat) in the input data for the logistic regression switching model.}

\item{strata_main_effect_only}{Whether to only include the strata main
effects in the logistic regression switching model. Defaults to
\code{TRUE}, otherwise all possible strata combinations will be
considered in the switching model.}

\item{ns_df}{Degrees of freedom for the natural cubic spline for
visit-specific intercepts of the pooled logistic regression model.
Defaults to 3 for two internal knots at the 33 and 67 percentiles
of the treatment switching times.}

\item{firth}{Whether the Firth's bias reducing penalized likelihood
should be used.}

\item{flic}{Whether to apply intercept correction to obtain more
accurate predicted probabilities.}

\item{low_psi}{The lower limit of the causal parameter.}

\item{hi_psi}{The upper limit of the causal parameter.}

\item{n_eval_z}{The number of points between \code{low_psi} and
\code{hi_psi} (inclusive) at which to evaluate the Wald
statistics for the coefficient of the counterfactual in the logistic
regression switching model.}

\item{recensor}{Whether to apply recensoring to counterfactual
survival times. Defaults to \code{TRUE}.}

\item{admin_recensor_only}{Whether to apply recensoring to administrative
censoring times only. Defaults to \code{TRUE}. If \code{FALSE},
recensoring will be applied to the actual censoring times for dropouts.}

\item{swtrt_control_only}{Whether treatment switching occurred only in
the control group. The default is \code{TRUE}.}

\item{gridsearch}{Whether to use grid search to estimate the causal
parameter \code{psi}. Defaults to \code{TRUE}, otherwise, a root
finding algorithm will be used.}

\item{root_finding}{Character string specifying the univariate
root-finding algorithm to use. Options are \code{"brent"} (default)
for Brent's method, or \code{"bisection"} for the bisection method.}

\item{alpha}{The significance level to calculate confidence intervals.}

\item{ties}{The method for handling ties in the Cox model, either
"breslow" or "efron" (default).}

\item{tol}{The desired accuracy (convergence tolerance) for \code{psi}
for the root finding algorithm.}

\item{offset}{The offset to calculate the time from disease progression
to death or censoring, the time from disease progression to treatment
switch, and the time from treatment switch to death or censoring.
We can set \code{offset} equal to 0 (no offset), and 1 (default),
1/30.4375, or 1/365.25 if the time unit is day, month, or year,
respectively.}

\item{boot}{Whether to use bootstrap to obtain the confidence
interval for hazard ratio. Defaults to \code{TRUE}.}

\item{n_boot}{The number of bootstrap samples.}

\item{seed}{The seed to reproduce the bootstrap results. The default is
\code{NA}, in which case, the seed from the environment will be used.}
}
\value{
A list with the following components:
\itemize{
\item \code{psi}: The estimated causal parameter for the control group.
\item \code{psi_roots}: Vector of \code{psi} values for the control group
at which the Z-statistic is zero, identified using grid search and
linear interpolation.
\item \code{psi_CI}: The confidence interval for \code{psi}.
\item \code{psi_CI_type}: The type of confidence interval for \code{psi},
i.e., "grid search", "root finding", or "bootstrap".
\item \code{logrank_pvalue}: The two-sided p-value of the log-rank test
for the ITT analysis.
\item \code{cox_pvalue}: The two-sided p-value for treatment effect based on
the Cox model applied to counterfactual unswitched survival times.
If \code{boot} is \code{TRUE}, this value represents the
bootstrap p-value.
\item \code{hr}: The estimated hazard ratio from the Cox model.
\item \code{hr_CI}: The confidence interval for hazard ratio.
\item \code{hr_CI_type}: The type of confidence interval for hazard ratio,
either "Cox model" or "bootstrap".
\item \code{event_summary}: A data frame containing the count and percentage
of deaths, disease progressions, and switches by treatment arm.
\item \code{data_switch}: The list of input data for the time from
disease progression to switch by treatment group. The variables
include \code{id}, \code{stratum}, \code{"swtrt"},
and \code{"swtrt_time"}. If \code{swtrt == 0}, then \code{swtrt_time}
is censored at the time from disease progression to death or censoring.
\item \code{km_switch}: The list of Kaplan-Meier plot data for the
time from disease progression to switch by treatment group.
\item \code{eval_z}: The list of data by treatment group containing
the Wald statistics for the coefficient of the counterfactual
in the logistic regression switching model, evaluated at
a sequence of \code{psi} values. Used to plot and check
if the range of \code{psi} values to search for the solution
and limits of confidence interval of \code{psi} need be modified.
\item \code{data_nullcox}: The list of input data for counterfactual
survival times for the null Cox model by treatment group.
The variables include \code{id}, \code{stratum},
\code{"t_star"} and \code{"d_star"}.
\item \code{fit_nullcox}: The list of fitted null Cox models for
counterfactual survival times by treatment group, which contains
the martingale residuals.
\item \code{data_logis}: The list of input data for pooled logistic
regression models for treatment switching using g-estimation.
The variables include \code{id}, \code{stratum},
\code{"tstart"}, \code{"tstop"}, \code{"cross"},
\code{"counterfactual"}, \code{conf_cov}, \code{ns},
\code{pd_time}, \code{swtrt}, and \code{swtrt_time}.
\item \code{fit_logis}: The list of fitted pooled logistic regression
models for treatment switching using g-estimation.
\item \code{data_outcome}: The input data for the outcome Cox model
of counterfactual unswitched survival times.
The variables include \code{id}, \code{stratum}, \code{"t_star"},
\code{"d_star"}, \code{"treated"}, \code{base_cov} and \code{treat}.
\item \code{km_outcome}: The Kaplan-Meier estimates of the survival
functions for the treatment and control groups based on the
counterfactual unswitched survival times.
\item \code{lr_outcome}: The log-rank test results for the treatment
effect based on the counterfactual unswitched survival times.
\item \code{fit_outcome}: The fitted outcome Cox model.
\item \code{fail}: Whether a model fails to converge.
\item \code{psimissing}: Whether the \code{psi} parameter cannot be estimated.
\item \code{settings}: A list containing the input parameter values.
\item \code{psi_trt}: The estimated causal parameter for the experimental
group if \code{swtrt_control_only} is \code{FALSE}.
\item \code{psi_trt_roots}: Vector of \code{psi_trt} values for the
experimental group at which the Z-statistic is zero, identified using
grid search and linear interpolation, if \code{swtrt_control_only}
is \code{FALSE}.
\item \code{psi_trt_CI}: The confidence interval for \code{psi_trt} if
\code{swtrt_control_only} is \code{FALSE}.
\item \code{fail_boots}: The indicators for failed bootstrap samples
if \code{boot} is \code{TRUE}.
\item \code{fail_boots_data}: The data for failed bootstrap samples
if \code{boot} is \code{TRUE}.
\item \code{hr_boots}: The bootstrap hazard ratio estimates
if \code{boot} is \code{TRUE}.
\item \code{psi_boots}: The bootstrap \code{psi} estimates
if \code{boot} is \code{TRUE}.
\item \code{psi_trt_boots}: The bootstrap \code{psi_trt} estimates
if \code{boot} is \code{TRUE} and \code{swtrt_control_only} is
\code{FALSE}.
}
}
\description{
Estimates the causal parameter using g-estimation by
fitting a pooled logistic regression switching model that includes
counterfactual \emph{unswitched} survival times and time-dependent
confounders as covariates. The adjusted hazard ratio is then obtained
from the Cox model using counterfactual \emph{unswitched} survival
times based on the estimated causal parameter.
}
\details{
Assuming one-way switching from control to treatment, the
hazard ratio and confidence interval under a no-switching scenario
are obtained as follows:
\itemize{
\item Fit a pooled logistic regression switching model among control-arm
patients who experienced disease progression:
\deqn{\text{logit}(p(E_{ik})) = \alpha U_{i,\psi} + \sum_{j} \beta_j 
  x_{ijk}}
where \eqn{E_{ik}} is the switch indicator for subject \eqn{i} at
observation \eqn{k},
\deqn{U_{i,\psi} = T_{C_i} + e^{\psi}T_{E_i}} is the counterfactual
survival time given a specific \eqn{\psi}, and \eqn{x_{ijk}}
represents the time-dependent confounders.
Natural cubic splines of time can be included to model time-varying
baseline hazards. \eqn{U_{i,\psi}} is defined relative to the
secondary baseline at disease progression and represents
post-progression counterfactual survival, where \eqn{T_{C_i}} and
\eqn{T_{E_i}} correspond to  time spent after progression on control
and experimental treatments, respectively.
Martingale residuals may be used in place of counterfactual survival
times to account for censoring.
\item Identify the value of \eqn{\psi} for which the Z-statistic of
\eqn{\alpha} is approximately zero. This value is the causal
parameter estimate.
\item Compute counterfactual survival times for control patients using
the estimated  \eqn{\psi}.
\item Fit a Cox model to the observed survival times for the treatment group
and the counterfactual survival times for the control group to
estimate the hazard ratio.
\item When bootstrapping is used, derive the confidence interval and
p-value for the hazard ratio from a t-distribution with
\code{n_boot - 1} degrees of freedom.
}

If treatment switching occurs before or in the absence of recorded disease
progression, the patient is considered to have progressed at the time of
treatment switching.

If grid search is used to estimate \eqn{\psi}, the estimated \eqn{\psi}
is the one with the smallest absolute value among those at which
the Z-statistic is zero based on linear interpolation.
If root finding is used, the estimated \eqn{\psi} is
the solution to the equation where the Z-statistic is zero.
}
\examples{

library(dplyr)

sim1 <- tsegestsim(
  n = 500, allocation1 = 2, allocation2 = 1, pbprog = 0.5, 
  trtlghr = -0.5, bprogsl = 0.3, shape1 = 1.8, 
  scale1 = 360, shape2 = 1.7, scale2 = 688, 
  pmix = 0.5, admin = 5000, pcatnotrtbprog = 0.5, 
  pcattrtbprog = 0.25, pcatnotrt = 0.2, pcattrt = 0.1, 
  catmult = 0.5, tdxo = 1, ppoor = 0.1, pgood = 0.04, 
  ppoormet = 0.4, pgoodmet = 0.2, xomult = 1.4188308, 
  milestone = 546, outputRawDataset = 1, seed = 2000)
  
data1 <- sim1$paneldata \%>\%
  mutate(visit7on = ifelse(progressed, tstop > timePFSobs + 105, 0))

fit1 <- tsegest(
  data = data1, id = "id", 
  tstart = "tstart", tstop = "tstop", event = "event", 
  treat = "trtrand", censor_time = "censor_time", 
  pd = "progressed", pd_time = "timePFSobs", 
  swtrt = "xo", swtrt_time = "xotime", 
  base_cov = "bprog", 
  conf_cov = c("bprog*cattdc", "timePFSobs", "visit7on"), 
  ns_df = 3, low_psi = -1, hi_psi = 1, n_eval_z = 101,
  recensor = TRUE, admin_recensor_only = TRUE, 
  swtrt_control_only = TRUE, alpha = 0.05, ties = "efron", 
  tol = 1.0e-6, offset = 0, boot = FALSE)
  
fit1

}
\references{
NR Latimer, IR White, K Tilling, and U Siebert.
Improved two-stage estimation to adjust for treatment switching in
randomised trials: g-estimation to address time-dependent confounding.
Statistical Methods in Medical Research. 2020;29(10):2900-2918.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
