% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{truh}
\alias{truh}
\title{TRUH test statistic}
\usage{
truh(V, U, B, fc = 1, ncores = 2, seed = 1)
}
\arguments{
\item{V}{\eqn{m\times d} matrix where \eqn{m} represents the sample size and
\eqn{d} is the dimension of each sample.}

\item{U}{a \eqn{n\times d} matrix where \eqn{n} represents the sample size and
\eqn{d} is the dimension of each sample with \eqn{m\ll n}.}

\item{B}{number of bootstrap samples.}

\item{fc}{fold change constant. The default value is 1. See equation (2.8) of the referenced paper for more details.}

\item{ncores}{the number of computing cores available. The default value is 2.}

\item{seed}{random seed for replicability. The default value is 1.}
}
\value{
\enumerate{
\item teststat - TRUH test statistic.
\item k.hat - number of clusters detected in the uninfected sample.
\item pval - The maximum p-value across the detected clusters.
\item pval_all - p-value for each cluster.
\item dist.null_all - the approximate bootstrapped based null distribution.
}
}
\description{
TRUH test statistic for nonparametric two sample testing under heterogeneity.
}
\examples{
library(truh)
n = 500
m = 10
d = 3
set.seed(1)
V = matrix(rnorm(m*d),nrow=m,ncol=d)
set.seed(2)
U = matrix(rnorm(n*d),nrow=n,ncol=d)
out = truh(V,U,100)

}
\references{
Banerjee, Trambak, Bhaswar B. Bhattacharya, and Gourab Mukherjee.
"A nearest-neighbor based nonparametric test for viral remodeling in
heterogeneous single-cell proteomic data."
The Annals of Applied Statistics 14, no. 4 (2020): 1777-1805.
}
\seealso{
\code{\link{nearest}}
}
