#'Function to obtain bootstrap confidence intervals (percentile) 
#'
#'@param bootrepl bootsrap replicates
#'@param level confidence level
#'@return The function returns the bootstrap confidence intervals as a two-column matrix with one row per parameter
#'@importFrom stats quantile
#'@export

bootconfint <- function(bootrepl,level)
{
	k <- ncol(bootrepl)
	bootconfint <- matrix(0,k,2)
	for(i in 1:k)
	{
		bootconfint[i,1] <- quantile(bootrepl[,i], (1-level)/2) 			
		bootconfint[i,2] <- quantile(bootrepl[,i], 1-(1-level)/2)			
	}
return(bootconfint)
}
	
