% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiled_code_tslstmx.R
\name{check_and_format_data}
\alias{check_and_format_data}
\title{Check and Format Data}
\usage{
check_and_format_data(data, n.head = 6)
}
\arguments{
\item{data}{A data frame containing a 'Date' column and a numeric column 'A'.}

\item{n.head}{Number of rows to display from the formatted data frame (default is 6).}
}
\value{
A formatted data frame with the specified number of rows displayed.
}
\description{
This function checks the compatibility of a given data frame and performs necessary formatting.
}
\details{
This function checks the format of the 'Date' column and ensures it is in the format 'dd-mm-yy'.
It also checks the presence of the 'A' column and ensures it contains numeric values.
}
\examples{
\donttest{
data <- data.frame(
  Date = as.Date(c("01-04-18", "02-04-18", "03-04-18", "04-04-18", "05-04-18",
                   "06-04-18", "07-04-18", "08-04-18", "09-04-18", "10-04-18",
                   "11-04-18", "12-04-18", "13-04-18", "14-04-18", "15-04-18",
                   "16-04-18", "17-04-18", "18-04-18", "19-04-18", "20-04-18"),
                 format = "\%d-\%m-\%y"),
  A = c(0, 0, 4, 12, 20, 16, 16, 0, 12, 18, 12, 18, 18, 0, 0, 33, 31, 38, 76, 198)
)
check_and_format_data(data)
# Add a new column 'X' based on the values in the second column
data$X <- ifelse(data$A != 0, 1, 0)
}
}
