% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp.r
\name{splinedecomp}
\alias{splinedecomp}
\title{\code{splinedecomp} decomposes a time series into trend, season and irregular component
by spline approach.}
\usage{
splinedecomp(x, d, alpha, beta, Plot = FALSE)
}
\arguments{
\item{x}{the series, a vector or a time series}

\item{d}{seasonal period}

\item{alpha}{smoothing parameter for trend component   (The larger alpha is, the smoother will the smooth component g be.)}

\item{beta}{smoothing parameter for  seasonal component}

\item{Plot}{logical, should a plot be produced?}
}
\value{
out (n,3) matrix:
\item{1. column}{smooth component }
\item{2. column}{seasonal component }
\item{3. column}{irregular component    }
}
\description{
\code{splinedecomp} decomposes a time series into trend, season and irregular component
by spline approach.
}
\examples{
data(GDP)
out  <- splinedecomp(GDP,4,2,4,Plot=FALSE) 
}
