% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{process_time}
\alias{process_time}
\title{POSIXct Processing}
\usage{
process_time(x, second_precision = 3600, method = ceiling, ...)
}
\arguments{
\item{x}{a POSIXct vector}

\item{second_precision}{the precision in seconds on which the processing operates on}

\item{method}{the method for processing}

\item{\dots}{not used}
}
\value{
POSIXct object
}
\description{
Ceiling, Floor and Other operations on a POSIXct object
}
\examples{
# end of hour
process_time(as.POSIXct('2022-08-03 03:00:01', tz = 'UTC'), 3600, method = ceiling)
# start of hour
process_time(as.POSIXct('2022-08-03 03:00:01', tz = 'UTC'), 3600, method = floor)
# end of minute
process_time(as.POSIXct('2022-08-03 03:00:01', tz = 'UTC'), 60, method = ceiling)
}
\author{
Alexios Galanos
}
