% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvinecopula3.R
\name{dvinecopula3}
\alias{dvinecopula3}
\title{Constructor function for dvinecopula3 process}
\usage{
dvinecopula3(
  location = 1,
  family = "gumbel",
  posrot = 0,
  negrot = 90,
  kpacf = "kpacf_arma",
  pars = list(ar = 0.1, ma = 0.1),
  auxpar = NA,
  maxlag = Inf
)
}
\arguments{
\item{location}{vector of locations of non-Gaussian copula substitutions}

\item{family}{vector of family names for non-Gaussian copula substitutions}

\item{posrot}{vector of rotations for substituted families under positive dependence (default is 0)}

\item{negrot}{vector of rotations for substituted families under negative dependence (default is 90)}

\item{kpacf}{a character string giving the name of the Kendall pacf}

\item{pars}{a list containing the parameters of the model}

\item{auxpar}{vector of additional parameters for two-parameter copulas}

\item{maxlag}{a scalar specifying the maximum lag}
}
\value{
An object of class \linkS4class{dvinecopula3}.
}
\description{
This function sets up a stationary d-vine process of finite or infinite order based on a
sequence of Gaussian copulas with a finite number of non-Gaussian substitutions at specified lags.
The substituted families can be Gumbel, Clayton, Joe, Frank, t and BB1 copulas as implemented by the
\code{\link[rvinecopulib]{bicop_dist}} in the \code{rvinecopulib} package.
}
\details{
For the substituted copulas (other than t and Frank) the user must specify the rotation that should be used for
positive dependencies (0 or 180) and the rotation that should be used for negative dependencies (90 or 270).

The copulas are parameterized using the Kendall partial autocorrelation function (kpacf) specified
by the \code{kpacf} argument. The default choice is the kpacf of a standard ARMA process which is
implemented in the function \code{\link{kpacf_arma}}. The parameters
of the kpacf should be set as a list using the \code{pars} argument; the required parameters should usually
be clear from the documentation of the chosen kpacf function and must be correctly named.

The \code{maxlag} parameter specifies the maximum lag of the process; a finite number gives a finite-order
stationary d-vine process, but the parameter may also be set to \code{Inf} for an infinite-order process.

If one or more of the substituted copulas are t or BB1 copulas the argument \code{auxpar} should be used to
specify the additional parameters. These are the degree-of-freedom parameter for t and the delta parameter for BB1;
the former must be greater or equal 2 and the latter greater or equal 1.
}
\examples{
dvinecopula3(location = c(1,4), family = c("Gumbel", "clayton"),
posrot = c(0, 180), negrot = c(90, 270), kpacf = "kpacf_arma",
pars = list(ar = 0.95, ma = 0.85), maxlag = 20)
}
