% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_basic.R
\name{fit,tscopulafit-method}
\alias{fit,tscopulafit-method}
\title{Fit method for tscopulafit class}
\usage{
\S4method{fit}{tscopulafit}(x, y, tsoptions = list(), control = list(warn.1d.NelderMead = FALSE))
}
\arguments{
\item{x}{an object of class \linkS4class{tscopulafit}.}

\item{y}{vector or time series of data to which the copula process is to be fitted.}

\item{tsoptions}{list of options}

\item{control}{list of control parameters to be passed to the
\code{\link[stats]{optim}} function.}
}
\value{
An object of class \linkS4class{tscopulafit}.
}
\description{
Fit method for tscopulafit class
}
\examples{
ar1 <- armacopula(list(ar = 0.7))
data <- sim(ar1, 1000)
ar1fit <- fit(fit(ar1, data), sim(ar1, 1000))
}
