% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specification.R
\name{garch_modelspec}
\alias{garch_modelspec}
\title{GARCH Model Specification}
\usage{
garch_modelspec(
  y,
  model = "garch",
  constant = FALSE,
  order = c(1, 1),
  variance_targeting = FALSE,
  vreg = NULL,
  multiplicative = FALSE,
  init = c("unconditional", "sample", "backcast"),
  backcast_lambda = 0.7,
  sample_n = 10,
  distribution = "norm",
  ...
)
}
\arguments{
\item{y}{an xts vector.}

\item{model}{the type of GARCH model. Valid choices are \dQuote{garch} for
vanilla GARCH, \dQuote{gjr} for asymmetric GARCH, \dQuote{egarch} for
exponential GARCH, \dQuote{aparch} for asymmetric power ARCH,
\dQuote{csGARCH} for the component GARCH, \dQuote{igarch} for the integrated
GARCH.}

\item{constant}{whether to estimate a constant (mean) for y,}

\item{order}{the (p,q) GARCH order.}

\item{variance_targeting}{whether to use variance targeting rather than
estimating the conditional variance intercept.}

\item{vreg}{an optional xts matrix of regressors in the conditional variance
equation.}

\item{multiplicative}{whether to exponentiate the contribution of the
regressors else will be additive. In the case of the \dQuote{egarch} model,
since this is already a multiplicative model, the regressors are additive
irrespective of the choice made.}

\item{init}{the method to use to initialize the recursion of the conditional
variance.}

\item{backcast_lambda}{the decay power for the exponential smoothing used
when initializing the recursion using the backcast method.}

\item{sample_n}{the number of data points to use when initializing the
recursion using the sample method.}

\item{distribution}{a valid distribution from the available
re-parameterized distributions of the package.}

\item{...}{not used.}
}
\value{
An object of class \dQuote{tsgarch.spec}.
}
\description{
Specifies a GARCH model prior to estimation.
}
\details{
The specification object holds the information and data which is
then passed to the maximum likelihood estimation routines.
}
\author{
Alexios Galanos
}
