% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastingdata_org.R
\name{monash_forecasting_repository}
\alias{monash_forecasting_repository}
\title{Get data from the Monash Forecasting Repository}
\usage{
monash_forecasting_repository(record_id)
}
\arguments{
\item{record_id}{Record ID of the dataset to be downloaded from the Monash Time Series Forecasting Repository. A complete table of datasets which can be obtained with this function can be found here: \url{https://forecastingdata.org/#datasets}. From this link, the data's \code{record_id} can be found in the URL of the download link provided in the table (it should look like https://zenodo.org/record/<Record ID>). This can also simply be a link to the zenodo record.}
}
\value{
A tsibble.
}
\description{
This function downloads datasets from the Monash Time Series Forecasting
Repository (\url{https://forecastingdata.org/}) and reads them in as a tsibble.
Downloaded data will be stored locally, allowing subsequent use of the data
without downloading. By default, the data is stored the appropriate
application data directory which varies by your operating system. The storage
path for these datasets can be changed by setting the \code{rpkg_tsibbledata}
option with \verb{options(rpkg_tsibbledata = /path/to/datadir)}
}
\details{
Datasets from this repository are stored in a tsf file format, which stores
time series metadata at the top of the file. This function uses this metadata
to produce a tsibble dataset, ready for analysis in R. For more details on
the repository and the tsf file format, please refer to: Godahewa, R.,
Bergmeir, C., Webb, G. I., Hyndman, R. J. & Montero-Manso, P. (2021), Monash
Time Series Forecasting Archive.
}
\references{
Godahewa, R., Bergmeir, C., Webb, G. I., Hyndman, R. J. & Montero-Manso, P. (2021), Monash Time Series Forecasting Repository. \url{https://forecastingdata.org/}

Godahewa, R., Bergmeir, C., Webb, G. I., Hyndman, R. J. & Montero-Manso, P. (2021), Monash Time Series Forecasting Archive.
}
