% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_gminmax.R
\name{ts_norm_gminmax}
\alias{ts_norm_gminmax}
\title{Global Min–Max Normalization}
\usage{
ts_norm_gminmax(outliers = outliers_boxplot())
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}
}
\value{
A \code{ts_norm_gminmax} object.
}
\description{
Rescale values so the global minimum maps to 0 and the global
maximum maps to 1 over the training set.
}
\details{
The same scaling is applied to inputs and inverted on predictions
via \code{inverse_transform}.
}
\examples{
# Global min–max normalization across the full training set
# Load package and example data
library(daltoolbox)
data(tsd)

# Build 10-lag windows and preview raw scale
ts <- ts_data(tsd$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# Fit global min–max and transform; inspect post-scale values
preproc <- ts_norm_gminmax()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
\references{
Ogasawara, E., Murta, L., Zimbrão, G., Mattoso, M. (2009). Neural networks
cartridges for data mining on time series. Proceedings of the International
Joint Conference on Neural Networks (IJCNN). doi:10.1109/IJCNN.2009.5178615
}
