% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_monthly_hs.R
\name{sim_monthly_hs}
\alias{sim_monthly_hs}
\title{Simulate a monthly time series based on the HS model}
\usage{
sim_monthly_hs(
  N,
  multiplicative = TRUE,
  sizeSeasonality = 100,
  sizeTrend = 100,
  sizeDrift = 100,
  sizeSeasonalityAux = 100,
  varIrregularity = 1,
  start = 2020,
  sizeBurnIn = 24,
  shockLevel = 1,
  shockDrift = 1,
  shockSeasonality = 1,
  index = 100
)
}
\arguments{
\item{N}{Length of the simulated time series in years.}

\item{multiplicative}{If true, a multiplicative model is simulated, an additive model if FALSE.}

\item{sizeSeasonality}{Size and stability of the annual seasonal factor.}

\item{sizeTrend}{Size and stability of the trend component.}

\item{sizeDrift}{Size and stability of the drift of the trend component.}

\item{sizeSeasonalityAux}{Size of the auxiliary variable for the annual seasonal factor.}

\item{varIrregularity}{Variance of the random irregular component.}

\item{start}{The initial date or year.}

\item{sizeBurnIn}{Size of burn-in sample in months.}

\item{shockLevel}{Variance of the shock to the level (trend).}

\item{shockDrift}{Variance of the shock to the drift (trend).}

\item{shockSeasonality}{Variance of the shock to the annual seasonal.}

\item{index}{A value to which the mean of the base year (first effective year) of the time series is normalized.}
}
\value{
Multiple simulated monthly time series of class xts including:
\describe{
\item{original}{The original series}
\item{seas_adj}{The original series without seasonal effects}
\item{sfac}{The seasonal effect}
}
}
\description{
This function simulates a monthly time series with a Monte Carlo simulation based
on an STS model based on Harvey and Shephard (1993) (HS model).
The monthly data consists of a trend, annual seasonal and
irregular component. The components are each simulated by a transition process
with monthly random shocks and then combined at the end of the simulation to form the complete time series.
}
\details{
The impact of a component on the time series depends on its ratio to
the other components. To increase (decrease) a component's impact, the value of
the size needs to be increased (decreased) while the other components need to be
kept constant. Therefore, the stability of the component (e.g. the shape of a seasonal component)
also grows as the shocks on the given component have less impact.
In order to increase the impact without increasing the stability, the variance
of the shock also needs to be raised accordingly.
The size of the components are defaulted to 100 each and the variances of the shocks are defaulted to 1.

The first effective year serves as base year for the time series
}
\examples{
x <- sim_monthly_hs(4)
ts.plot(x[,1])
}
\references{
Cuevas, Ángel and Quilis, Enrique M., Seasonal Adjustment Methods for Daily Time Series. A Comparison by a Monte Carlo Experiment (December 20, 2023). Available at SSRN: https://ssrn.com/abstract=4670922 or http://dx.doi.org/10.2139/ssrn.4670922

Structural Time Series (STS) Monte Carlo simulation Z = trend + seasonal_weekly + seasonal_annual + irregular, according to Harvey and Shephard (1993): "Structural Time Series Models",in Maddala, G.S., Rao, C.R. and Vinod, H.D. (Eds.) Handbook of Statistics, vol. 11, Elsevier Science Publishers.
}
\author{
Nikolas Fritz, Daniel Ollech, based on code provided by Ángel Cuevas and Enrique M Quilis
}
